Procedure Instructions;
{On-screen tutorial (very brief, since disk should have documentation)}
Begin;
   ClrScr;                          {Show first file}
   File_name := 'WGINS1.TXT';
   ShowText;
   GotoXY(5,10);
   Colour_Selection;                  {Demonstrate grid and solar system box}
   Draw_Grid;
   Writeln;
   Writeln('Star grid used in this program:'#10#13' Each square is a light-year across');
   Writeln(' A total of 1000 cubic light years');
   Beep_Wait;
   If Demonstration = 2 then exit;
   Protected_System := System_Details [2,4]; {safeguard this system (if any)}
   System_Details [2,4] := '246G5    0   2 1 4   5   6   7 8 9 S   ';
   Y_Coordinate := 2;
   X_Coordinate := 4;
   Old_Systems;
   System_Location_XYZ;
   Writeln('This system is at coordinates 2,4,6');
   Beep_Wait; If Demonstration = 2 then exit;
   Writeln;
   Graphwindow(0,0,319,199);
   Old_System_Map;
   Graphwindow(0,33,319,199);
   ClearScreen;
   Graphwindow(0,0,319,199);
   File_name := 'WGINS2.TXT';
   ShowText;
   ClearScreen;
   System_Details [2,4] := '246*'+CHR(10)+'    4 0 2 3 9 0 3 3       0       ';
   Old_System_Map;
   Graphwindow(300,33,315,66);
   Black_Hole;
   Graphwindow(300,66,315,99);
   Proto_Star;
   Graphwindow(0,0,319,199);
   GotoXY(1,5);
   File_name := 'WGINS3.TXT';
   ShowText;
   TextMode(C80);
   GotoXY(1,1);
   File_name := 'WGINS4.TXT';
   ShowText;
   ClrScr;
   GotoXY(1,1);
   File_name := 'WGINS5.TXT';
   ShowText;
   ClrScr;
   If Dummy <> 'S' then begin;
     Orrory(1);
     If Dummy <> 'X' then Planet_Details(1);
   End;
   Textmode(C80);
   ClrScr;
   File_name := 'WGINS6.TXT';
   ShowText;
   System_Details [2,4] := Protected_System; {return to original state}
   ClrScr;
End;

Procedure Draw_A_Globe;
Begin;
  For I := 1 to 200 Do Plot (Random(320),Random(200),Random(4));
  Writeln ('            World  Generator'#10#13' For Science Fiction Role-Playing Games');
  Writeln (#10#13'Copyright <C> Marcus L. Rowland 1987, 88');
  For I := -5 to 152 do
    Begin;
      R := Round (I/20);
      Circle (320-I,92+R,R,2);
      Circle (I,100,R,3);
      Circle (I,100,R+1,0);
      Circle (320-I,92+R,R+1,0);
      If keypressed then exit;
    End;
  Pattern(Grid);
  Fillpattern(40,39,280,159,1);
  For I := 0 to 54 Do Circle (160,99,I,3);
  Graphwindow(100,50,220,150);
  Slartibartfast(0,3,7,120);
  Graphwindow(0,0,319,219);
End;

Procedure Titles;
Begin;
  Draw_A_Globe;
  GotoXY(9,24);
  If Demonstration = 0 then Write('Press any key to continue')
   else write ('Press any key to interrupt');
  Beep_Wait; If Demonstration = 2 then exit;
  Textmode(C80);
  ClrScr;
  WG_Textcolor(yellow);
  File_Name := 'TITLES.TXT';
  Showtext;
End;

Procedure Rolling_Demonstration;
Begin;
  Top_Of_Menu_Screens;
  Writeln('Rolling Demonstration selected'#10#13'This procedure over-writes systems in memory.');
  Writeln('If you want to continue, press "Y";'#10#13'Press any other key to exit.');
  Beep_Wait;
  If Dummy <> 'Y' then exit;
  Demonstration := 1;
  Repeat
    Colour_Selection;
    Titles;
    If Demonstration = 1 then Instructions;
    If demonstration = 1 then Read_Data;
    If demonstration = 1 then Sector_Statistics(0);
    If demonstration = 1 then solar_systems;
    If demonstration = 1 then Grand_Tour;
  Until Demonstration <> 1;
  Demonstration := 0;
End;
