Procedure Frame(V: integer);
{Part of mapper procedure; V is colour}
  Begin;

Draw (0,0,219,0,V);
  Draw (0,99,219,99,V);
  Draw (0,0,0,99,V);
  Draw (219,99,219,0,V);
  End;

Procedure Percentages;
Begin;
   Numbers(205,1,1,3);
   Numbers(210,1,0,3);
   Numbers(215,1,0,3);
   Numbers(205,18,0,3);
End;

Procedure Square_Grid;
{Draw a square box containing a grid to show axial tilt  or  asteroid  belt
inclination}
Begin;
   GraphWindow(0,34,99,133);
   Pattern(Grid);
   FillPattern(2,1,98,98,3);
   Fillshape(0,0,3,3);
End;

Procedure Orbit_Box;
{Draw another box for a map of orbits}
Begin;
   Graphwindow(0,134,99,199);
   Pattern(Grid);
   Fillpattern(2,1,98,65,1);
   A := Copy (WG_System,4,1);
   If A < 'A' then
      Begin;
       Circle(49,32,1,2);
       Fillshape(49,32,2,2);
       Circle(51,34,1,2);
       Fillshape(51,34,2,2);
      end
    else
      begin;
       Circle(50,33,2,2);
       Fillshape(50,33,2,2);
      end;
End;

Procedure Show_World_Data;
{show the planet's atmosphere etc.}
Begin;
   Graphwindow(100,134,319,199);
   For N := 0 to 8 do
       Begin;
         V := N*24+5;
         Draw(V,1,V,21,1);
         Gas_Level := 21- (Atmosphere [N] div 5);
         Draw(V,21,V,Gas_Level,2);
         Draw(V-1,Gas_Level,V+1,Gas_Level,2);
       End;
   Percentages;
   GotoXY(14,21);
   Write('H He  O N Hal Ar CO H O CH');
   Numbers(210,32,4,2);
   Numbers(175,32,2,2);
   Numbers(155,32,2,2);
   GotoXY(14,22);
   If Planet_Code >='A' then if Planet_Code <= 'M' then
     Write('Star type = ',Star_Type,'  ');
   Write('g =',Pull);
   If Planet_Code = '0' then write(' <Av.>');
   GotoXY(14,23);
   Write('Av. Temperature ',Heat,' K');
   GotoXY(14,24);
   If ((Planet_Code >='0') AND (Planet_Code <= '9')) OR
      (Planet_Code = 'R') then Write('Pressure: ',Air_Force,' [Earth = 1]');
   GotoXY(14,25);
   Write('M:Map D:Data     X:eXit');
End;

Procedure Binary_Star_Data;
{Show data for a binary star}
Begin;
   Graphwindow(100,134,319,199);
   For N := 0 to 3 do Draw(N*50+5,1,N*50+5,21,1);
   GotoXY(14,21);
   Write('H     He    H     He');
   GotoXY(14,22);
   Write('Star 1      Star 2');
   For V := 0 to 1 do
   Begin;
     For N:= 0 to 1 do
       Begin;
       Gas_Level := 21- (Binary_Star_Atmosphere[V,N] div 5);
       Draw((V*100)+(N*50)+5,Gas_Level,(V*100)+(N*50)+5,21,2);
       Draw((V*100)+(N*50)+4,Gas_Level,(V*100)+(N*50)+6,Gas_Level,2);
     end;
     Percentages;
     GotoXY(14+(12*V),23);
     Write('Type = ',Binary_Star_Type[V]);
     Str(Binary_Star_Temperature[V]:6:0,Heat);
     GotoXY(14+(12*V),24);
     Write(Heat,' K');
     Str(Binary_Star_G[V]:5:0,Pull);
     GotoXY(14+(12*V),25);
     Write('g =',Pull);
   End;
End;

Procedure Black_Hole_Data;
  Begin;
    Graphwindow(100,134,319,199);
    GotoXY(14,18);
    Write('No data on composition');
    GotoXY(14,19);
    Write('Estimated g = ',Pull);
    GotoXY(14,20);
    Write('Mass = ',Exact_Mass:5:0,' [Sol = 1]');
    GotoXY(14,21);
    Write('Temperature unknown');
    GotoXY(14,22);
    Write('WARNING - LETHAL RADIATION');
    GotoXY(14,23);
    Write('THROUGHOUT SYSTEM!');
    GotoXY(14,25);
    Write('M:Map D:Data     X:eXit')
  End;

Procedure Prepare_Atmosphere_etc;
{Set atmospheric gasses and moon sizes to zero before generating them}
Begin;
 For N := 0 to 8 do
   Begin;
    Atmosphere[N] := 0;
   End;
 For N := 0 to 20 do
   Begin;
    Moon_Size[n] := -1;  {flag for no moon}
    For V:= 1 to 3 do Moon_Colonies[N,V] := 0;
   End;
 Pressure := 0.0;
 Tilt := 0;
 Native_Life := 0;
 Native_Technology:= 0;
 Colonies[1] := 0;
 Colonies[2] := 0;
 Colonies[3] := 0;
End;

Procedure Orbital_Eccentricity;
{Draw a circle representing eccentricity of planet orbit}
Begin;
   Graphwindow(0,134,99,199);
   Eccentricity_X := 0;
   Eccentricity_Y := 0;
   If Planet_Code <> 'Q' then if Planet_Code <> 'R' then begin;
     If Mean_Eccentricity > 0.1 then Eccentricity_X := Random(2)-Random(2);
     If Mean_Eccentricity > 0.3 then Eccentricity_Y := Random(2)-Random(2);
   end else Circle(50,33,Planet_Number,2);
   Circle(50+Eccentricity_X, 33+Eccentricity_Y,Planet_Number*3,3);
End;

Procedure World_Frame (V: Integer);
{Part of World_Mapper}
Begin;
   Colortable(3,0,1,2);
   x := 0;
   Frame(-1);
   Draw(0,50,219,50,-1);         {Equator}
   Repeat;
      Plot (X,Tilt Div 2,-1);         {Arctic zones}
      Plot (X,100-(Tilt Div 2),-1);    {Antarctic}
      Plot (X,50-(Tilt Div 2),-1);     {Tropics}
      Plot (X,50+(Tilt Div 2),-1);
      X := X + 4;
   Until X>219;
   For N := 0 to 9 do Numbers(20+(N*20),93,N,-1);
   Colortable(0,1,2,3);
End;

Procedure Colony_Marker(X,Y,Z: Integer);
Begin;
   For N:= -2 to 2 do begin;
     Draw(X-2,Y+N,X+2,Y+N,0);
     If N>-2 then if N<2 then draw(X-1,Y+N,X+1,Y+N,Z);
   end;
   If Screen_Selection <> 2 then plot(X-2+Z,Y,0);
end;

Procedure Determine_Colonies(Maxcol:Integer);
Begin;
  For V:= 1 to 2 do begin;
    Colonies[V] := Random(Maxcol);
    If Native_Technology>5 then colonies[v] := random(2); {bright natives won't accept colonies}
    If Colonies[v] <0 then colonies[V] := 0;
  end;
End;

Procedure Show_Moons;
{To show moons of small planets where there is a map on the main screen}
Begin;
   GraphWindow(0,104,99,133);
   Clearscreen;
   Pattern(Grid);
   FillPattern(2,4,98,28,3);
   Fillshape(0,0,3,3);
   Circle (15,16,11,2);
   Fillshape(15,15,1,2);
   For V := 1 to 3 do If Moon_Size[v] <> -1 then
      Begin;
      Circle (15+(V*20),16,Moon_Size[V] +1,0);
      Circle (15+(V*20),16,Moon_Size[V],2);
      For N:= 1 to 3 do begin;
        If Moon_Colonies[V,N] >0 then Colony_Marker(15+(V*20),15+(4*N),N);
      End;
   End;
End;

Procedure Show_Tilt;
{part of world mapping routine, shows a planet's inclination}
{uses turtle graphics}
Begin;
   Square_Grid;
   Circle(50,50,40,2);
   Fillshape(50,50,1,2);
   TurtleWindow(50,84,99,99);
   SetHeading(Tilt);
   SetPenColor(2);
   Back(45);
   Forwd(90);
   Penup;
   SetPenColor(0);
   Back(15);
   TurnLeft(90);
   Forwd(7);
   PenDown;
   TurnRight(90);
   Forwd(5);
   TurnRight(150);
   Forwd(6);
   Turnleft(150);
   Forwd(5);
   Home;
   SetHeading(Tilt+90);
   SetPencolor(0);
   Forwd(45);
   Back(90);
   If Planet_Code >'0' then if Planet_Code < '6' then Show_Moons;
End;

Procedure Slartibartfast(Colour_1, Colour_2, Frequency, R_Limit: Integer);
{fill in areas with meaningful-looking crinkly patterns in colour_1 on
background colour_2, or overlay splodges of the same colour}
Begin;
  For X := 0 to R_Limit do For Y := 0 to 100 do
       Begin;
         If Colour_1 <5 then {overlay one colour with another}
           If getdotcolor(X,Y) = Colour_2 then
            if Random(Frequency) = 0
             then circle (X,Y,Random(2),Colour_1);
         If Colour_1 = 5 then   {overlay several colours}
            if Random(Frequency) = 0
            then if GetDotColor(X,Y) > Colour_2
               then circle (X,Y,Random(2),GetDotColor(X,Y));
       End;
End;

Procedure Icecaps;
{similar to Slartibartfast but edge-weighted}
Begin;
  For x:= 0 to 220 do For y:= 1 to 50 do begin;
    If random (50) > y+Tilt then circle(X,Y,Random(3),1);
    If random (50) > y+Tilt then circle(x,100-y,Random(3),1);
  end;
end;

Procedure Set_Random_XY;
Begin;
  X := Random(210)+5;
  Y := Random(50)+ Random(50);
End;

Procedure Craters(X,Y,Z: Integer);
Begin;
   Circle(X,Y,Z,1);
   Fillshape(X,Y,2,1);
   Fillshape(X,Y,3,1);
   Circle(X,Y,Z,0);
End;

Procedure Choose_System(V : Integer);
{part of world generation and solar system editing options
if V is 1, world generation, if it is 2, editing, if 3 statistics}
Begin;
  If Systems_In_Memory = 0 then begin;
     No_Sector_Error;
     Exit;
  end;
  Repeat
    Status := 2;
    ClrScr;
    Top_Of_Menu_Screens;
    WG_Textcolor(LightGreen);
    Write ('            SOLAR SYSTEM ');
    case V of
      1: If Astral = 0 then writeln ('MAPPING')
          else Writeln ('CHART');
      2: writeln ('EDITING');
      3: writeln ('STATISTICS');
      5: Writeln ('DISTANCES [from selected system]');
    end;
    WG_Textcolor(Yellow);
    Writeln('[S] Quick SCAN through sector before choosing');
    Writeln('[M] MOVE around sector and choose system');
    Writeln('[C] Select system by COORDINATES');
    Writeln(#10#13'[X] eXit to main menu'#10#10#13'[H] HELP');
    Repeat;
        Beep_Wait;
        Menu_Status := 9;
        Case Dummy of
        'X' : Menu_Status := 0;
        'S' : Menu_Status := 1;
        'M' : Menu_Status := 2;
        'C' : Menu_Status := 3;
        'H' : Menu_Status := 4;
        end;
   Until Menu_Status <>9;

   If Menu_Status = 4 then HELP('MOVE',' SMCX');
   If Menu_Status = 0 then exit;
   If Menu_Status = 1 then Solar_Systems;
   If Menu_Status = 2 then begin;
       Steer_Around_Sector;
       If System_Details [Y_Coordinate, X_Coordinate] > '!'
         then begin;
            Menu_Status := 3;
            Exit;
         end
         else Menu_Status :=9;
       End;
   If Menu_Status = 3 then begin;
      WG_Textcolor(LightRed);
      Writeln('Enter first two digits of location code');
      Writeln('As shown in bottom left under sun');
      WG_Textcolor(LightBlue);
      Repeat;
        Read(A,B);
        If A >= '0' then if A <= '9' then Val(A,Y_Coordinate,R) else
                      Y_Coordinate := -1;
        If B >= '0' then if B <= '9' then Val(B,X_Coordinate,R) else
                      Y_Coordinate := -1;
      Until Y_Coordinate <> -1;
      Writeln(' System location ',Y_Coordinate,X_Coordinate);
      If System_Details [Y_Coordinate, X_Coordinate] <= '!' then
      If V = 1 then
      begin;
        WG_Textcolor(White + Blink);
        Writeln('No system at these coordinates - try again');
        WG_Textcolor(Yellow);
        Delay(1000);
        Menu_Status := 9;
      end
      else Menu_Status := 3;
    end;
Until Menu_Status = 3;
End;

Procedure Draw_Belt(Beltcolour : Integer);
{Part of asteroid belt, dust cloud, and ringworld mapping}
Begin;
  Circle (110,-175,269+Belt_Width,Beltcolour);
  Circle (110,-175,255,Beltcolour);
  Fillshape(110,90,Beltcolour,Beltcolour);
  Circle (110,300,294+Belt_Width,Beltcolour);
  Circle (110,300,292,Beltcolour);
  Fillshape(110,6,Beltcolour,Beltcolour);
End;

Procedure Check_Star_Type(V: Integer);
{part of Show_belt_or_ring_suns}
Begin;
 Star_Type := Copy (WG_System, 4 +(2*V),2);
 If Star_Type = 'B0' then Star_Radius := 10 else
 If Star_Type = 'B5' then Star_Radius := 4 else
 If Star_Type = 'A0' then Star_Radius := 3 else
 If Star_Type = 'A5' then Star_Radius := 2 else
 star_Radius := 1;
End;

Procedure Show_belt_or_ring_suns;
{Part of asteroid belt, dust ring, and ringworld mapping}
Begin;
  A := Copy (WG_System,4,1);
  If A>='A' then
    begin;
     Check_Star_Type(0);
     Circle(110,50,Star_Radius,3);
     Fillshape(110,50,2,3);
    end
  else begin;
    GraphWindow(205,69,215,99);
    if A = '(' then black_Hole;
    If A = ')' then Proto_star;
    if A = '*' then Binary_Star;
  end;
  GraphWindow (100,34,319,133);
  For V := 1 to Planet_Number do
    Begin;
     B := Copy (WG_System, 4 +(2*V),1);
     If B >= 'A' then if B<'M' then begin;
       Check_Star_Type(V);
       Circle (110 + ((110 DIV Planet_Number) * V), 50, Star_Radius,3);
       Fillshape(110 + ((110 DIV Planet_Number) * V), 50, 2,3);
     End;
    End;
  Square_Grid;
  Circle (50,50,4,2);
  Fillshape(50,50,2,2);
  Fillshape(50,50,0,3);
  Circle(50,50,40,2);
  Circle(50,50,40+Belt_Width,2);
  If Planet_Code <> 'S' then Fillshape(50,91,2,2);
  A := Copy (WG_System,4,1);
   If A < 'A' then
      Begin;
       Circle(49,49,2,2);
       Fillshape(49,49,3,2);
       Circle(51,51,2,2);
       Fillshape(51,51,3,2);
      end
    else
      begin;
       Circle(50,50,2,2);
       Fillshape(50,50,3,2);
      end;
End;

Procedure Oxygen_Atmosphere_etc;
{for world and ringworld}
Begin;
  {Prepare atmospheric data}
  Tilt := Random(8)+Random(8);
  Atmosphere[2] := Random(10) + 5;
  Atmosphere[7] := Random(3);
  Atmosphere[6] := Random(5);
  Atmosphere[5] := Random(10);
  Atmosphere[3] := 100-(Atmosphere[2]+Atmosphere[7]+Atmosphere[6]+Atmosphere[5]);
  Gravity := 0.75 + Random;
  Pressure := Sqr (Gravity);
  Temperature := Temperature + 10 * Pressure; {greenhouse effect}
  Native_Life := random(6)+Random(5)+1; {oxygen worlds always have life, if only plants}
  If Planet_code = 'R' then Native_Life := 10; {bright!}
  If Native_Life >6 then Native_Technology := Random(Native_Life-6) + Random(10);
  If Planet_Code = 'R' then native_Technology := 9 + Random(9);
  If Native_Technology>0 then Colonies[3] := Native_Technology + Random(Native_Technology);
  Determine_Colonies(5);
End;

Procedure Poison_Atmosphere;
{for poison worlds and non-human ringworlds}
Begin;
     Tilt := Random(25);
     {Prepare atmospheric data}
     If Temperature > 250 then begin;
       {common poisonous type}
       Atmosphere[8] := Random(40);
       Atmosphere[6] := Random(10);
       Atmosphere[5] := Random(20);
       Atmosphere[4] := Random(5);
       Atmosphere[3] := 100-(Atmosphere[8]+Atmosphere[6]+Atmosphere[5]+Atmosphere[4]);
       Pressure := Sqr(Gravity) * 50; {High pressure}
       Temperature := Temperature + Pressure; {greenhouse effect}
     end else begin;
       {cold Halogen atmosphere}
       Atmosphere[4] := 50 + Random(30);
       Atmosphere[5] := Random (100-Atmosphere[4]);
       Atmosphere[3] := 100-(Atmosphere[3] + Atmosphere [4]);
       Pressure := Sqr (Gravity);  {low pressure}
     end;
     Native_Life := 10-Random(500); {usually no life or low forms}
     If Planet_code = 'Q' then Native_Life := 10; {bright!}
     If Native_Life >6 then Native_Technology := Random(Native_Life-6) + Random(10);
     If Planet_Code = 'Q' then native_Technology := 9 + Random(9);
     If Native_Technology>0 then Colonies[3] := Native_Technology;
     If Temperature > 100 then if temperature < 1000 then
       Determine_Colonies(2);
 end;

Procedure Show_Colonies(Background_Colour: Integer);
Begin;
for V:= 1 to 3 do
   if Colonies[V] > 0 then begin;
         For NN:= 1 to Colonies[V] do begin;
            If Background_Colour <> 5 then begin;
               Repeat Set_Random_XY Until Getdotcolor(X,Y) = Background_Colour;
               Colony_Marker(X,Y,V);
            end else begin;
               Set_Random_XY;
               Colony_Marker(X,Y,V);
            end;
         End;
     End;
End;

Procedure Mountains(Colour_1,Colour_2,Ruggedness: Integer);
Begin;
     For N:= 1 to Ruggedness do begin;
     Repeat Set_Random_XY Until GetDotColor(X,Y) = Colour_1;
       For I := 1 to 5 * Ruggedness do begin;
         Repeat;
           X := X+2 - Random(5);
           Y := Y+2 - Random(5);
           If X>219 then X := 0;
           if X<0 then X := 219;
           If Y>99 then Y := Y-2;
           If Y<0 then Y := Y+2;
         Until GetDotColor(X,Y) = Colour_1;
         Craters(X,Y,Random(2)+1);
         Fillshape(X,Y,Colour_2,0);
       End;
     End;
End;

Procedure Grid_Scale;
Begin;
    Magnification := 14;
    Pattern(Grid);
    FillPattern(2,1,218,98,1);
    If Exact_Radius <= 0.8 then begin;
      ClearScreen;
      Magnification := 70;
      Draw(0,30,220,30,1);
      Draw(0,70,220,70,1);
      For N:= 0 to 6 do Draw(10+(40*N),0,10+(40*N),100,1);
    end;
    If Exact_Radius <= 0.4 then begin;
      ClearScreen;
      Magnification := 140;
      Draw(0,10,220,10,1);
      Draw(0,90,220,90,1);
      For N:= 0 to 3 do Draw(10+(80*N),0,10+(80*N),100,1);
    end;
    If Exact_Radius <= 0.2 then begin;
      ClearScreen;
      Magnification := 280;
      Draw(10,0,10,100,1);
      Draw(170,0,170,100,1);
    end;
end;

{------- Map printing routines ---------}


Procedure Save_Map; {Transfer the map to a buffer}
Begin;
  Getpic(Map_Buffer,0,0,219,99);
end;

Procedure Restore_Map;
Begin;
  GraphWindow (100,34,319,133);
  Putpic(Map_Buffer,0,99);
end;

Procedure Map_Dump; {special screen dump utilities, for Epson compatible
or CGP-115 plotter-printer}
Const
  Pen_Table : Array [1..3] of String[2] = ('C2','C3','C1');
Var
  MapX,MapY : Integer;
   MapChars : Array [0..4] of Char;
    mapByte : Array [0..4] of Byte;
  ThisPixel : Byte;
     MapCnt : Byte;
          N : Integer;
             Plotter_Y: Integer;
      Plotter_String_X: String[15]; {Probably too long}
      Plotter_String_Y: String[15]; {Probably too long}
        Plotter_String: String[15]; {Probably too long}
    Palette_Selection : Integer;
             Pen_Down : Integer;

begin;
  GraphWindow (100,34,319,133);
  If Map_Choice = 0 then begin;
    Writesafe(1,(#27+'3'+#15)); {space enough for 5 dots with 6th line overlapping}
    if not OK then exit;
    MapX := 0;
    While MapX <=219 do begin;
      Writesafe(0,(#27+'K'+#144+#1));
      if not OK then exit;
      for N := 0 to 99 do begin;
          MapY := 99-N;
          For MapCnt := 1 to 4 do MapByte[MapCnt] := 0;
          ThisPixel := GetDotColor(MapX,MapY);
          If (MapY = 99) Or (ThisPixel <> Getdotcolor(MapX,MapY+1)) then MapByte[1] := 252;
          If (MapX = 0) Or (ThisPixel <> Getdotcolor(MapX-1,MapY)) then
             For MapCnt := 1 to 4 do if MapByte[MapCnt] < 252 then MapByte[MapCnt] := 128;
          If MapX = 219 then
            For MapCnt := 1 to 4 do if MapByte[MapCnt] < 252 then
              MapByte[MapCnt] := MapByte[MapCnt] + 4;
          If MapY = 0 then MapByte[4] := 252;
          For MapCnt := 1 to 4 do Writesafe(0,(Char(MapByte[MapCnt])));
          if not OK then exit;
      end;
      Writesafe(1,'');
      If not OK then exit;
    MapX := MapX + 1;
    end;
  end
  else if map_choice = 1 then begin;
    Writesafe(1,#27+'3'+#10); {no space between lines}
    Writesafe(1,#15);   {condensed}
    If Not OK then exit;
    MapChars[0] := ' '; MapChars[1] := '+'; MapChars[2] := '*';  MapChars[3] := 'x';
    For MapX := 0 to 219 do begin;
      for MapY := 0 to 99 do Writesafe(0,MapChars[GetDotColor(MapX,99-MapY)]);
      If Not OK then exit;
      Writesafe(1,'');
    end;
  end
  else if Map_choice = 2 then begin;
    { --- EXTREMELY slow routine for plotter --- }
    Writesafe(1,#17);
    For W := 1 to 5 do Writesafe(1,''); {move paper up}
    Writesafe(1,#18);  {Set for graphics}
    Delay(500); {needed by plotter}
    Writesafe(1,'I');                           {Set pen position as home}
    For W := 1 to 3 do  {non-background colours}
    Begin;
      Writesafe(1,Pen_Table[W]); {select colour}
      Writesafe(1,'H'); {return to home}
      For Y := 0 to 99 do Begin;
        Str (0-(Y*2),Plotter_String_Y);
        Writesafe (1,'M0,-' + Plotter_String_Y); {move to appropriate line}
        If Getdotcolor (X,Y) = W then Pen_Down := 1 else Pen_Down := 0;
        For X:= 0 to 220 do begin;
          If Keypressed then exit;
          If (Pen_Down = 1) and (Getdotcolor(X,Y+1) <> W)
          then begin;
            Str (2*X,Plotter_String_X);
            Writesafe (1,'D' + Plotter_String_X + ',' + Plotter_String_Y);
            Pen_Down := 0;
          end;
          If (Pen_Down = 0) and (Getdotcolor(X,Y+1) = W)
          then begin;
            Str (2*X,Plotter_String_X);
            Writesafe (1,'M' + Plotter_String_X + ',' + Plotter_String_Y);
            Pen_Down := 1;
          end;
        end;
      end;
    end;
    Writesafe(1,#17);
    For W := 1 to 5 do Writesafe(1,''); {move paper up}
  end
  else if Map_Choice = 3 then begin;
    {fast small epson-compatible map}
    Writesafe(1,(#27+'3'+#9)); {space enough for 4 dots with 4th line overlapping}
    if not OK then exit;
    MapY := 0;
    While MapY <=99 do begin;
      Writesafe(0,(#27+'K'+#184+#1));
      if not OK then exit;
      for mapX := 0 to 219 do begin;
          For MapCnt := 1 to 2 do MapByte[MapCnt] := 0;
          ThisPixel := GetDotColor(MapX,MapY);
          If (MapX = 0) Or (ThisPixel <> Getdotcolor(MapX-1,MapY)) then MapByte[1] := 240;
          If (MapY = 0) Or (ThisPixel <> Getdotcolor(MapX,MapY-1)) then
             For MapCnt := 1 to 2 do if MapByte[MapCnt] < 240 then MapByte[MapCnt] := 128;
          If MapY = 99 then
            For MapCnt := 1 to 2 do if MapByte[MapCnt] < 240 then
              MapByte[MapCnt] := MapByte[MapCnt] + 16;
          If MapX = 219 then MapByte[2] := 252;
          For MapCnt := 1 to 2 do Writesafe(0,(Char(MapByte[MapCnt])));
          if not OK then exit;
      end;
      Writesafe(1,'');
      If not OK then exit;
    MapY := MapY + 1;
    end;
  end;
  If Map_Choice <> 2 then
  Writesafe(1,#27+'2'+#27+'P'+#18);
end;


Procedure Find_Map_area; {part of special maps below}
Begin;
 Repeat;
   GotoXY(14,25);
   Write(#27#24#25#26,':Move ',#28#16,':Zoom    X:eXit');
   Getpic(Cursor_Buffer,Cursor_X,Cursor_Y,Cursor_X+21,Cursor_Y+9);
   Old_Cursor_X := Cursor_X;
   Old_Cursor_Y := Cursor_Y;
   Colortable(1,2,3,0);
   PutPic(Cursor_Buffer,Cursor_X,Cursor_Y+9);
   Read(Kbd,Dummy);
   Dummy := Upcase(Dummy);
   If (Dummy = #27) and KeyPressed then begin;
      read (Kbd,Dummy);
      Case Dummy of
      'K': if Cursor_X > 0 then Cursor_X := Cursor_X - 22;
      'M': if Cursor_X < 190 then Cursor_X := Cursor_X + 22;
      'H': if Cursor_Y > 0 then Cursor_Y := Cursor_Y - 10;
      'P': if Cursor_Y < 90 then Cursor_Y := Cursor_Y + 10;
      end;
   end;
 Colortable(0,1,2,3);
 PutPic(Cursor_Buffer,Old_Cursor_X,Old_Cursor_Y+9);
 Until (Dummy = #13) or (Dummy = 'X');
End;

Procedure Zoom_Map;{part of special_maps below}
Begin;
 RandSeed := Old_Seed[0] + Old_Seed[1] + Cursor_X + Cursor_Y;
 Fillscreen(0);
 Putpic(Cursor_Buffer,198,99);
 For YY:= 0 to 9 do for XX := 0 to 22 do begin;
    Graphwindow(298,124,319,133);
    Continent := GetDotColor(XX,YY);
    GraphWindow(100+(XX*10),33+(YY*10),110+(XX*10),43+(YY*10));
    Fillscreen(Continent);
 end;
 GraphWindow (100,33,319,133);
 Slartibartfast(5,-1,2,219);
 Draw(0,0,219,0,0);
 GraphWindow (100,34,319,133);
 Frame(0);
 GotoXY(14,25);
 Write('P:Print Other Keys:Zoom out');
 Beep_Wait;
 If Dummy = 'P' then Map_Dump
   else Dummy := ' ';
End;

Procedure Special_Maps;
{extra details for planets (not gas giants or asteroids}
Begin;
   Cursor_X:= 0;
   Cursor_Y:= 0;
   Repeat;
     Restore_Map;
     GotoXY(14,25);
     Write('P:Print Z:Zoom G:Grd X:eXit');
     Beep_Wait;
     If Dummy = 'P' then Map_Dump;
     If Dummy = 'G' then begin;
       For N:= 1 to 9 do draw (N*22,0,N*22,100,0);
       For N:= 1 to 9 do draw (0,N*10,219,N*10,0);
       GotoXY(14,25);
       Write('P:Print Other Keys:Grid off');
       Beep_Wait;
       If Dummy = 'P' then Map_Dump;
       Dummy := ' ';
     end;
     If Dummy = 'Z' then Begin;
       Find_Map_Area;
       If Dummy <> 'X' then Zoom_Map;
       Dummy := ' ';
     End;
   Until Dummy = 'X';
end;

{-------- Orrory & planetarium special routines --------------}

Procedure Big_Orbit_Box;
Begin;
   Turtlewindow (159,117,320,167);
   Home;
   Wrap;
   SetPenColor(1);
   Forwd(180);
   Home;
   Turnleft(90);
   Forwd(330);
   If Astral = 1 then begin;
      A := Copy (WG_System,4,1);
      If A>='A' then begin;
        Check_Star_Type(0);
        Circle(159,82,1+Round(Star_Radius/1.5),3);
        Fillshape(159,82,2,3);
      end
      else begin;
        GraphWindow(154,102,170,129);
        if A = '(' then black_Hole;
        If A = ')' then Proto_star;
        if A = '*' then Binary_Star;
      end;
  end;
End;

Procedure Ring_Around(Col: Byte);
Begin;
  SetPencolor(3);
  For N:= 1 to 40 do begin;
    Old_X := XX;
    Old_Y := YY;
    Penup;
    Home;
    Setheading(current_Angle[Planet_Number] + (N*9));
    Forwd(Round(Planet_Number * 4.8));
    XX := 159 + (Xcor * 2);
    YY := Ycor + 82;
    draw(XX,YY-2,Old_X,Old_Y-2,0);
    draw(XX,YY-1,Old_X,Old_Y-1,3);
    For nn := 0 to 1 do
      If Odd(n) then draw(XX,YY+nn,Old_X,Old_Y+nn,Col);
    draw(XX,YY+2,Old_X,Old_Y+2,3);
    draw(XX,YY+3,Old_X,Old_Y+3,0);
    If odd(n) then
    draw(159-((159-XX)div 3),(82-((82-YY)div 3)),(159-((159-Old_X)div 3)),(82-((82-Old_Y)div 3)),3);
  End;
End;

Procedure Dust_About(col, Number: Integer);
Begin;
  Penup;
  For N:= 1 to Number do begin;
    Home;
    Setheading(Random(360)+Current_angle[planet_Number]);
    Forwd(1-Random(3)+Round(Planet_Number * 4.8));
    XX := 159 + (Xcor * 2);
    YY := Ycor + 82;
    Plot(XX,YY,col);
  End;
End;

Procedure Teeny_Planet(Xplace,Yplane,Yplace,Colout,colin,size: Byte);
Begin;
  Draw(Xplace,Yplace,Xplace,Yplane,1);
  Circle(Xplace,Yplace,Size+1,0);
  Circle(Xplace,Yplace,Size,Colout);
  Fillshape(Xplace,Yplace,colin,colout);
End;

Procedure Plot_Planet_Position(Planet_Number: Integer);
{assumes a starting date in 1970 (anyone for Omphalism?) and finds
the current position of the planet, asteroids, ringworld, or whatever, then
shows it - not to scale!}
Begin;
  Turtlewindow (159,117,320,167);
  SetPenColor(2);
  Penup;
  Home;
  Initial_Angle := Random(360);
  Angle_Per_Day := (365.25 / 360) / Orbital_Period;
  Total_Angle := Initial_Angle + (Angle_Per_Day * Days_Since);
  If Total_Angle >360.0 then repeat Total_Angle := Total_Angle - 360.0 until Total_Angle < 360.0;
  Setheading(Round(Total_Angle));
  Current_Angle[Planet_Number] := Heading;
  Forwd(Round(Planet_Number * 4.8));
  XX := 159 + (Xcor * 2);
  YY := Ycor + 82;
  Y1 := YY-Round(Ycor*Mean_eccentricity);
  Plot (XX,Y1,2);
  If Astral = 1 then Case Char(Ord(Planet_Code[1])) of
     'Q': Ring_Around(2);
     'R': Ring_Around(1);
     'S': Dust_About(3,200);
     '0': Dust_About(2,50+ Random(50));
     '1': Teeny_Planet(XX,YY,Y1,1,1,1);
'2'..'9': Teeny_Planet(XX,YY,Y1,3,3,1);
'A'..'M': Teeny_Planet(XX,YY,Y1,3,2,Star_Radius);
  End;
End;
