{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$I+}    {I/O checking on}
{$N-}    {No numeric coprocessor}

Program World_Generator_One; {version 1.2}
 {This program produces solar systems for SF role playing games,  but  is
 not directly based on the rules of any one game. It requires an IBM PC
 or clone with CGA graphics board, RGB monitor, Dos 2.0 or later.
 Written in Turbo Pascal version 3.1, re-compiled with additional features
 under version 4.0

 Copyright <c> - By Marcus L. Rowland - 1987, 1988, 1989
                 22, Westbourne Park Villas,
                 London W2 5EA,
                 ENGLAND

PLEASE READ DOCUMENTATION FOR CONDITIONS OF DISTRIBUTION ETC.}

Uses CRT, Printer, Dos, Graph, Turbo3, Graph3, WG1; {declares units, holds variables and procedures used throughout program}

{-------------------------------------------------------------------------}
{     PROCEDURES USED IN FAST SOLAR SYSTEM MAPPING & GENERATION ETC.      }
{-------------------------------------------------------------------------}

{$I WG2.INC} {load the stuff for solar system generation and disk I/O}

{-------------------------------------------------------------------------}
{        PROCEDURES FOR GENERATION OF DETAILED PLANET AND STAR DATA       }
{-------------------------------------------------------------------------}
{$I WG5.INC} {load stuff used in print-out phase}
{$I WG6.INC} {stuff for planet mapping, map printing, and planetarium}



{-------------------------------------------------------------------------}
{                        MAIN MAPPING PROCEDURES                          }
{-------------------------------------------------------------------------}

Procedure Asteroid_Belt_Mapper;
{Draw an asteroid belt}
Begin;
  Belt_Width := Random(5) + 1;
  Gravity := 0.01 * Random;
  Pressure := 0;
  For V:= 1 to 2 do Colonies[V] := Random(3)*Random(3);
  If (Statistics_Status <> -1) or (Astral <> 0) then exit;
  Draw_Belt(2);
  For X := 0 to 219 do
     Begin;
     For Y := 0 to 100 do
       Begin;
       if GetDotColor(X,Y) = 2 then if Random(35 - Belt_Width) = 0 then begin;
           Z := Random(4);
           If Y < 51 then Z := 0;
           Circle(x,y,Z+1,0);
           Fillshape(X,Y,0,0);
           Circle (X,Y,Z,3);
           Fillshape(X,Y,Z,3);
       End;
    End;
  End;
  Frame(0);
  Fillshape(0,0,2,3);
  Fillshape(0,0,0,3);
  Show_Colonies(3);
  Frame(2);
  Show_Belt_or_Ring_suns;
End;

Procedure Dust_Cloud_Details;
{assumes a toroidal dust cloud orbiting a star, rather than a smaller "lump"
of dust. Assumes that dust blocks off heat from outer planets.}
 Begin;
   Belt_Width := Random(5) + 4;
   Gravity := 0;
   Pressure :=0;
   If (Statistics_Status <> -1) or (Astral <> 0) then exit;
   Draw_Belt(3);
   Slartibartfast(0,3,2,220);
   Slartibartfast(0,0,4,220);
   Frame(2);
   Show_Belt_or_Ring_Suns;
 End;

Procedure Ring_World_Details(builders: Integer);
{if builders = 1 then oxygen else poison type}
Begin;
  Belt_Width := 4 + Random(5);
  RW_Width := (1000000.0 * Belt_Width) + (Sqr(Random(1000)+1));
  If Builders = 1 then
     Oxygen_Atmosphere_etc
  else begin;
     Gravity := 0.5 + Random;
     Poison_Atmosphere;
  end;
  If (Statistics_Status <> -1) or (Astral <> 0) then exit;
  Draw_Belt(3);
  Fillshape(110,6,2,0);
  Fillshape(10,0,2,2);
  Fillshape(210,0,2,2);
  If builders = 1 then
     Slartibartfast(1,3,6,220)
  else
     Slartibartfast(2,3,6,220);
  For N := 0 to 5 do
    Begin;
      draw (110+20*N,50,110+24*N,100,0);
      draw (110-20*N,50,110-24*N,100,0);
    End;
  Fillshape(0,55,0,0); Fillshape(25,70,0,0); Fillshape(75,80,0,0);
  Fillshape(114,80,0,0); Fillshape(166,85,0,0); Fillshape(200,70,0,0);
  If builders = 1 then begin;
     GraphWindow (100,84,319,133);
     Fillshape(100,0,2,1);
     Fillshape(100,0,0,1);
  end;
  If Builders = 1 then Show_Colonies(builders) else Show_Colonies(3);
  GraphWindow (100,34,319,133);
  Circle (110,-175,272+Belt_Width,2);
  Circle (110,-175,254,2);
  IA := 10 + Belt_Width Div 2;
  For N := 0 to 37 do
  Begin;
      X := Round (110-105*Sin(n/6));
      Y := Round (45+25*Cos(n/6));
      If Y<45 then V := 2 else V := 3;
      If Odd (N) then For I := 0 to IA do begin;
        If I = IA then V := 0;
        draw (X,Y+I,Old_X,Old_Y+I,v);
      end;
      Old_X := X;
      Old_Y := Y;
    End;
  Belt_Width := 2;
  Frame(3);
  Show_Belt_or_Ring_suns;
End;

Procedure World_Mapper(World_Type: Integer);
{Draw a simple map of an earthlike (1) or uninhabitable (2) world}
Begin;
If World_Type = 2 then begin;
   Gravity := 0.5 + Random;
   For V := 1 to 3 do if random(10)< 2 then Moon_Size[V] := Random(2);
   Poison_Atmosphere;
end else begin;
   Oxygen_Atmosphere_etc;
   If Random (5) <3 then Moon_Size[3] := Random(3) + 3
        else Moon_Size[2] := Random(3) + 2;
   If Random(10)<2 then Moon_Size[1] := Random(2);
end;
Planet_Mass := Sqr(Gravity);
For V := 1 to 3 do
   Begin;
    if Moon_Size[V] > -1 then begin;
      If Native_Technology > 10 then if Random(3) = 0 then Moon_Colonies[V,3] := 1;
      For N:= 1 to 2 do If Random(10) = 0 then Moon_Colonies[V,N] := 1;
   End;
End;
If (Statistics_Status <> -1) or (Astral <> 0) then exit;
{Draw crude shapes; messy but fast}
If World_Type = 1 then if Gravity < 1.0 then if Temperature > 310.0 then fillshape(1,1,3,2);
If World_Type = 1 then Graphbackground(Blue);
Ratio := Random(20)+10;
    For y:= 1 to 19 do
       Begin;
       YY := Y*5;
         For X := 1 to 43 do
           begin;
            XX := X*5;
            Continent := getdotcolor(XX,YY);
               If Random(Ratio) < 1 then if Continent = 3
                 then continent := 0  else continent := 3;
               If X = 43 then continent := getdotcolor(5,YY);
             V := Random(6)+Random(6);
             Circle(XX,YY,V,1);
             Fillshape(XX,YY,1,1);
             Circle(XX,YY,V,continent);
             Fillshape(XX,YY,Continent,continent);
           End;
       End;
{now fill in the fine detail}
If World_Type = 2 then Mountains(0,2,Random(5)+5) else Mountains(3,2,Random(5)+5);
Slartibartfast(World_Type,3,3,220);
If World_Type = 2 then
   Begin;
     Frame(0);
     Fillshape(0,0,3,2);
   end;
Save_Map;
Show_Colonies(World_Type);
If World_Type = 1 then World_Frame(2) else begin;
     World_Frame(0);
     Frame(1);
    End;
Show_Tilt;
End;

Procedure Airless_World_Mapper;
{Draw an airless world; type 3 with craters,
type 4 with mountains, type 5 icy}
Begin;
  Native_Life := 10-Random(1000); {not likely!!}
  If Native_Life >6 then Native_Technology := Random(Native_Life-4) + Random(10);
  Colonies[3] := (Native_Technology);
  Determine_Colonies(4);
  If Temperature > 100 then if temperature < 1000 then
  For V := 1 to 3 do
   Begin;
    if random(10)< 2 then Moon_Size[V] := Random(2);
    If Moon_Size[V] >-1 then begin;
      If Native_Technology > 10 then if Random(3) = 0 then Moon_Colonies[V,3] := 1;
      For N:= 1 to 2 do If Random(20) = 0 then Moon_Colonies[V,N] := 1;
    End;
   End;
  Tilt := Random(20);
  Gravity := (Random + 0.1) / 2;
  Planet_Mass := Sqr(Gravity);
  If Temperature <300 then begin; {small hot worlds lose atmosphere}
    Atmosphere[3] := 80+Random(10);
    Atmosphere[5] := Random(100-Atmosphere[3]) + 1;
    Atmosphere[6] := 100-(Atmosphere[3]+Atmosphere[6]);
    Pressure := Sqr (gravity/5);
  End;
  If (Statistics_Status <> -1) or (Astral <>0) then exit;
  If Planet_Code = '3' then fillscreen(3) else fillscreen(2);

  {chuck in meteors for all types}
  For N := 1 to 200 do
    begin;
      Set_Random_XY;
      V := Random(4);
      If N<40 then V := Sqr(V);
      Craters(X,Y,V);
   End;

  {Mountains for type 4&5}
  If Planet_Code >= '4' then begin;
    Fillshape(0,0,2,3);
    Mountains(2,2,Random(10)+20);
    Frame(1);
    Fillshape(0,0,3,0);
  end;

  {icy bit for type 5}
  If Planet_Code = '5' then Icecaps;

  {final details}
  Save_map;
  Show_Colonies(0);
  World_Frame(2);
  Frame(1);
  Show_Tilt;
End;

Procedure Gas_Giant_Mapper(World_Type: Integer);
Begin;
    Tilt := Random(10)+ Random(10);
    If Random(100) = 0 then tilt := Tilt * 10;
    Atmosphere[0] := Random(50) + 40;
    Atmosphere[1] := 100 - Atmosphere [0];
    Gravity := 1.0 + (Random * 4.0);
    Planet_Mass := 150 * Gravity; {very rough!!!}
    Pressure := Sqr (Sqr (Gravity)); {a guess}
    Ring_Number := Random (10) + 2;
    Temperature := Temperature + 10 * Gravity; {possible core heating}
    If Random(2000) = 0 then native_life := Random(10); {not likely!!}
    If Native_Life >6 then Native_Technology := Random(Native_Life) + Random(10);
    Colonies[3] := Native_Technology;
    For V := World_Type to (World_Type * 2) do begin;
       If Random(10) > 3 then Moon_Size[V] := Random(3)+1;
       If Moon_Size[V] >-1 then begin;
         If Native_Technology > 12 then if Random(20) = 0 then Moon_Colonies[V,3] := 1;
         For N:= 1 to 2 do If Random(20) = 0 then Moon_Colonies[V,N] := 1;
       End;
    End;
  If (Statistics_Status <> -1) or (Astral <> 0) then exit;
  If World_Type > 7 then begin;
     Graphwindow(100,34,199,133);
     For V := 1 to Ring_Number do Circle(0-(3*v),450-V,413,Random(3)+1);
     For V := 0 to 45 do Circle (0,50,V,0);
  End;
  Circle(0,50,45,1);
  Fillshape(0,50,1,1);
  Circle(0,50,45,2);
  Fillshape(0,50,0,2);
  For Y := 6 to 94 do
  Begin;
    X := 0;
    Band := Random(4);
    Repeat
       Plot(X,Y,Band);
       If Random(3) = 0 then Circle(X,Y-1,Random(2),Band);
       X := X + 1
    Until GetDotColor(X,Y) = 2;
  End;
  Circle(0,50,46,0);
  Graphwindow(100,34,130,133);
  Show_Colonies(2);
  Graphwindow(100,34,199,133);
  If World_Type >7 then
    for V := -2 to Ring_Number do circle(0-(V*3),V-350,412,Random(3)+1);
  Graphwindow (100,34,319,165);
   For V := World_Type to (World_Type * 2) do
    If Moon_Size[V] > -1 then begin;
        circle((10 * V)+30,50,Moon_Size[v],3);
        For N:= 1 to 3 do begin;
        If Moon_Colonies[V,N] >0 then Colony_Marker ((V*10)+30,55+(4*N),N);
        End;
    End;
  Frame(2);
  Show_Tilt;
End;

Procedure Star_Details;
   Begin;
     If Planet_Number = 0 then Tilt := 0 else tilt := Random (5);
     Star_Type := Copy(WG_System,(Planet_Number*2) + 4,2);
     Get_Luminosity_Etc;
     Gravity := (Exact_mass * 29)/Sqr (Exact_Radius);
     If Planet_Number = 0 then Primary_Luminosity := Luminosity
        else Primary_Luminosity :=
           Primary_Luminosity + Luminosity / Planet_Number;
     If Planet_Number = 0 then Primary_Mass := Exact_Mass;
     Atmosphere[0] := 90 - Star_Radius; {probably crap}
     Atmosphere[1] := 100 - Atmosphere [0];
     If (Statistics_Status <> -1) or (Astral <> 0) then exit;
     Grid_Scale;
     Star_Display_Radius := Round (Exact_Radius * Magnification);
     Circle(10,50,Star_Display_Radius,3);
     Fillshape(10,50,3,3);
     circle (10,50,(Star_Display_Radius * Atmosphere[0]) div 100,2);
     Fillshape(10,50,2,2);
     If Star_Type <> 'DG' then Slartibartfast(5,1,Random(3)+2,Star_Display_Radius+15);  {extend yellow & red bits}
     Frame(1);
     Show_Tilt;
   End;

Procedure Binary_Star_Details;
{This procedure generates a simple map of a close binary star pair.
it assumes that, for each star, the mass of one star * it's distance from
the common centre of gravity will equal that of the opposite star. It also
surrounds both stars in a gas cloud. Both these assumptions are questionable.}
   Begin;
     Primary_Mass := 0;
     D := Copy(WG_System,(Planet_Number*2) + 5,1);
     Star_Selection := Ord (D[1]);
     For V:= 0 to 1 do begin;
       Get_Star_Type;
       Get_Luminosity_etc;
       Binary_Star_Luminosity[v] := Luminosity;
       Binary_Star_Temperature[v] := Temperature;
       Binary_Star_Mass[v] := Exact_Mass;
       Binary_Star_Radius[v] := Exact_Radius;
       Binary_Star_Type[v] := Star_type;
       Binary_Star_Atmosphere[V,0] := Random(10)+80;
       Binary_Star_Atmosphere[V,1] := 100 - Binary_Star_Atmosphere[V,0];
       Binary_Star_Distance[V] := Round(10 / Binary_Star_Mass[v]);
       Binary_Star_G[V] := (Exact_mass * 29.0)/Sqr (Exact_Radius);
       Primary_Mass := Primary_Mass + Binary_Star_Mass[v];
       Primary_Luminosity := Primary_Luminosity + Binary_Star_Luminosity[v];
       If V= 0 then Star_Selection := 100-Star_Selection;
     End;
     If (Statistics_Status <> -1) or (Astral <>0) then exit;
     Exact_Radius := Binary_Star_Radius[0]; {0 is bigger than 1}
     Grid_Scale;
     For V:= 0 to 1 do begin;
        Binary_Star_Size[V] := Round(Binary_Star_Radius[V] * Magnification);
        if V = 0 then Y := 110 - Binary_Star_Distance[V]
          else Y := 110 + Binary_Star_Distance[V];
        For X := 0 to Binary_Star_Size[V] do
            Circle (Y,50, X, 3);
        For X := 0 to (Binary_Star_Size[V] * Binary_Star_Atmosphere[V,0]) div 100 do Circle(Y,50,X,2);
        If v = 0 then Slartibartfast(5,1,Random(2)+2,220);  {any colour above 1}
     End;
     Circle(y,50,Binary_Star_Size[1]+1,0);
     Frame(1);
     Square_grid;
     for x := 0 to Binary_Star_Distance[1]+ Random(20) do circle(50,50,X,2); {Gas cloud around pair}
     For V := 0 to 1 do begin;
       if V= 0 then Y := 50 - (Binary_Star_Distance[V])
         else Y := 50 + (Binary_Star_Distance[V]);
       Circle(Y,Y,Round (Binary_Star_Radius[V])+2,3);
       Fillshape(Y,Y,0,3);
       Fillshape(Y,Y,2,3);
     End;
   End;

Procedure Black_Hole_Details;
{show a black hole}
   Begin;
     Luminosity := 0.0001;
     Exact_Mass := (Random (10) * 100) + Random(100) + Random;
     Primary_Mass := Exact_Mass;
     Exact_Radius := 0.0000005 * Exact_Mass;
     Gravity := (Exact_mass * 29)/Sqr (Exact_Radius);
     Ring_Number := Random (10) + 2;
     If (Statistics_Status <> -1) or (Astral <> 0) then exit;
     Grid_Scale;
     ClearScreen;
     GraphWindow (210,34,319,133);
     Star_Display_Radius := Round (Exact_Radius * Magnification * 50);
     For V := Star_Display_Radius Div 2 to Star_Display_Radius do Circle(0-(3*v),450-V,400,2);
     GraphWindow (100,34,210,133);
     For V := Star_Display_Radius Div 2 to Star_Display_Radius do Circle(100+(3*v),V-350,400,2);
     GraphWindow (100,34,319,133);
     For V:= 0 to Star_Display_Radius+2 do Circle(110,50,V,3);
     Craters(110,50,Star_Display_Radius+2);
     Circle(110,50,Star_Display_Radius+3,2);
     Fillshape(110,50,0,2);
     Slartibartfast(2,2,2,220);
     Frame(1);
     Square_Grid;
     Graphwindow(10,44,89,123);
     Slartibartfast(3,3,4,80); {gravitational distortion!}
     Graphwindow(20,54,79,113);
     Slartibartfast(3,3,3,60);
     Circle(30,30,2,0);
     Fillshape(30,30,0,0);
     Plot(30,30,2);
   End;

Procedure Protostar_Details;
Begin;
  Temperature := 5000.0 + (Random * Dust_Density * 100.0); {a wild guess}
  Primary_Temperature := Temperature / 2; {some lost in cloud}
  Exact_Mass := Random(5) + Random;
  Primary_Mass := Exact_Mass;
  Gravity := 15.0 + (Random * 10); {another guess}
  Atmosphere[0] := Random(10)+90; {mostly hydrogen with a leetle He}
  Atmosphere[1] := 100 - Atmosphere [0];
  Tilt := 0;
  Dust_Density := 50 + Random(100);
  If (Statistics_Status <> -1) or (Astral <>0) then exit;
  Pattern(Grid);
  Ring_Number := Dust_Density Div 10;
  FillPattern(2,1,218,98,1);
  GraphWindow (210,34,319,133);
  For V := 1 to Ring_Number do Circle(0-(3*v),450-V,413-Ring_Number,2);
  GraphWindow (100,34,319,133);
  For V:= 0 to Dust_Density Div 4 do Circle(110,50,V,0);
  Craters(110,50,Dust_Density Div 4);
  Circle(110,50,Dust_Density Div 4,2);
  Fillshape(110,50,2,2);
  Craters(110,50,Dust_Density Div 5);
  Circle(110,50,Dust_Density Div 5+1,0);
  GraphWindow (100,34,210 + (Dust_Density Div 7),133);
  For V := 1 to Ring_Number do Circle(100+(3*v),V-350,413-Ring_Number,2);
  GraphWindow (100,34,319,133);
  For N := 0 to Dust_Density Div 2 do
    Begin;
      Repeat;
        Set_Random_XY;
      Until GetDotColor(X,Y) = 2;
      V := Random(3);
      If y>35 then if y<65 then if X>50 then if X<170 then
           V := Sqr(V);
      Craters(X,Y,V);
      Circle(X,Y,V+1,0);
  End;
  Slartibartfast(5,1,3,220);  {any colour above 1}
  Frame(1);
  Square_Grid;
  Circle (50,50,Dust_Density Div 4, 2);
  Fillshape(51,51,2,2);
  Circle (50,50,Dust_Density Div 6,3);
  Fillshape(51,51,3,3);
  For N := 1 to dust_density do
    begin;
    Repeat;
      X := Random(100);
      Y := Random(100);
    Until GetDotColor(X,Y) = 2;
    Craters(X,Y,Random(3));
  End;
End;

{-------------------------------------------------------------------------}
{                    MAIN PLANET GENERATION PROCEDURE                     }
{-------------------------------------------------------------------------}

Procedure Planet_Details(Bypass : Integer);
{world generation}
Begin;
  If Bypass = 0 then Choose_System(1) else menu_status := 3;
  If Menu_Status = 3 then
      Begin;
        WG_System := System_Details [Y_Coordinate, X_Coordinate];
        If Security_Level > 1 then begin;
           Security_Tag := Copy(WG_System,40,1);
           If Security_tag = '*' then begin;
              Writeln ('ACCESS DENIED!!'#10#13'DATA ON SYSTEM RESTRICTED!');
              If Statistics_Status = -1 then Beep_Wait else Delay(1000);
              exit;
           end;
        end;
        If Statistics_Status <> 3 then Colour_Selection;
        TextColor(2);
        Body_Count := 0;
        Primary_Mass := 0;
        RandomSeed [0] := X_Coordinate + Y_Coordinate;
        Old_Seed [0] := RandomSeed [0];
        A := Copy(WG_System,3,1);
        Val(A,V,n);
        RandomSeed [1] := Sqr (V);
        Old_Seed [1] := Randomseed [1];
        System_Inclination := Random(360);
        Primary_Luminosity := 0;
        For Planet_Number := 0 to 17 Do
          Begin;
             Planet_Code := Copy(WG_System,(Planet_Number*2) + 4,1);
             If Planet_Code <> ' ' then
                Begin;
                Graphbackground(Black);
                Old_Systems;
                If (Statistics_Status <> 3) AND (Astral = 0) then ClearScreen;
                Old_System_Map;
                If Planet_Number > 0 then Body_Count := Body_Count +1;
                Val(Planet_Code,World_Type,Z);
                X :=  Planet_Number * 17 + 5;
                Randomseed [0] := Old_Seed [0] + Ord(Planet_Code[1]) + Body_Count;
                Old_Seed [0] := Randomseed [0];
                RandomSeed [1] := Old_Seed [1] + X;
                Old_Seed [1] := Randomseed [1];
                Randseed := Randomseed[0] + Randomseed[1];
                If Planet_Number > 0 then begin;
                  Orbital_Distance := Bode_Number [Planet_Number] * Primary_mass; {distance in AU}
                  Temperature := 374.5 * (Exp(Ln(Luminosity)/4)) / Sqrt (Orbital_Distance);
                  If temperature <=4.2 then temperature := 4.2;
                  Mean_Eccentricity := 0.01 * (Random (10)+1);
                  If Planet_Number >2 then if Planet_Number <15
                    then Mean_Eccentricity := Mean_Eccentricity * 0.5;
                  If Planet_Code = '0' then Mean_Eccentricity := Mean_Eccentricity * Random(20);
                  Mean_Eccentricity := Mean_Eccentricity * Sqr(Stars_In_System);
                  If Planet_Code >= 'A' then Mean_Eccentricity := 0.0;
                  If Random(2) = 0 then Mean_Eccentricity := 0.0 - Mean_eccentricity;
                  Orbital_Period :=
                    Sqrt ((Sqr(Orbital_Distance)* Orbital_Distance)/Primary_Mass);
                  Orbital_Period := Orbital_Period * 365.25; {convert to earth days}
                  if Planet_Code >= 'Q' then if Planet_Code <='R' then Begin;
                    Orbital_Distance := Orbital_Distance * 150 * 1.0E+9; {in metres!}
                    Gravity := Gravity * 9.81; {conversion to metres/sec}
                    Orbital_Velocity := Sqrt (Orbital_Distance * Gravity);
                    Circumference := Orbital_Distance * Pi * 2.0;
                    Orbital_Period := Circumference / Orbital_Velocity; {in seconds}
                    Orbital_Period := Orbital_Period / 86400.0; {in days}
                  End;
                  Circle(X,15,5,2);
                end;
                If Statistics_Status = -1 then if Astral = 0 then begin;
                  Graphwindow(100,134,319,199);
                  ClearScreen;
                  Graphwindow (0,34,99,133);
                  ClearScreen;
                  GraphWindow (100,34,319,133);
                  Clearscreen;
                End else Graphwindow (0,33,319,199);
                Prepare_Atmosphere_etc;
                Case Char(Ord(Planet_Code[1])) of
                   'Q': Ring_World_Details(2);
                   'R': Ring_World_Details(1);
                   'S': Dust_Cloud_Details;
                   '*': Binary_Star_Details;
                   '(': Black_Hole_Details;
                   ')': Protostar_Details;
                   '0': Asteroid_Belt_Mapper;
              '1'..'2': Begin; Val(Planet_Code,V,I); World_Mapper(V); End;
              '3'..'5': Airless_World_Mapper;
              '6'..'9': Gas_Giant_Mapper(World_Type);
              'A'..'M': Star_Details;
                  end;
                If Planet_Code <> '*' then begin;
                  If Gravity >1 then Str(Gravity:6:1,Pull) else Str(Gravity:5:4,Pull);
                    Str(Temperature:6:0,Heat);
                  If Planet_code = '(' then Str(Gravity:10:0,Pull);
                  If Pressure >1 then Str(Pressure:5:2,Air_Force) else Str(Pressure:5:4,Air_Force);
                End;
                If (Statistics_Status = -1) and (Astral = 0) then begin;
                  If Planet_Number = 0 then Orbit_Box
                  else Orbital_Eccentricity;
                  If Planet_Code = '*' then Binary_Star_Data
                     else if Planet_Code = '(' then  Black_Hole_Data
                       else Show_World_Data;
                  Beep_Wait;
                  If Demonstration = 2 then exit;
                end else if Astral <> 0 then begin;
                  If Planet_Number = 0 then Big_Orbit_Box;
                  If Planet_Number <> 0 then Plot_Planet_Position(Planet_Number);
                end else detailed_Print_out;
                if Dummy = 'D' then detailed_Print_out;
                If Dummy = 'X' then exit;
                If Dummy = 'M' then
                  If (Planet_Code> '0') And (Planet_Code < '6') then special_Maps
                    else map_dump;
                end;
          End;
       End;
   If Astral <> 0 then Beep_Wait;
   Menu_Status := 0;
   Randomize;
   If (Statistics_Status <> 3) And (Astral = 0) then Textmode(C80);
End;

Procedure Orrory(Bypass : Integer);
Begin;
  Astral := 1;
  Days_Since := (Year - 1970) * 365.25; {count days since 1970 - ignores current leap years}
  If Month >1 then for n := 1 to Month-1 do Days_Since := Days_Since + Days_In_Month[n];
  Days_Since := Days_Since + Day;
  Planet_Details(Bypass);
  Astral := 0;
End;

Procedure Grand_Tour; {zoom view of all planets in sector}
Begin;
    For Y_Coordinate := 0 to 9 Do
      For X_Coordinate := 0 to 9 Do
        If demonstration = 1 then Begin;
          WG_System := System_Details [Y_Coordinate, X_Coordinate];
          if WG_System > '!' then begin;
             Astral := 1;
             Orrory(1);
             Astral := 0;
             If demonstration = 1 then planet_details(1);
          end;
        end;
end;


{-------------------------------------------------------------------------}
{                  EDITING ROUTINES & STATISTICS                          }
{-------------------------------------------------------------------------}

{$I WG4.INC}

{-------------------------------------------------------------------------}
{                    TITLES, INSTRUCTIONS, ETC.                           }
{-------------------------------------------------------------------------}

{$I WG3.INC} {Load in this stuff}

{-------------------------------------------------------------------------}
{            THE MAIN PROGRAM!!!!!  & SPECIAL OPTIONS                     }
{-------------------------------------------------------------------------}

Procedure Special_Options;
{here there be strange lumpy bits of code that don't fit in very well
anywhere else}
Begin;
   Repeat
   Top_Of_Menu_Screens;
   Writeln('Special Program options'#10#13);
   Write('[B] BEEP on or off'#10#13'[T] Change beep TONE, currently : ',beep_pitch,#10#13'[C] Change COLOUR palette to ');
   Case Screen_Selection of
    0 : Writeln ('Mono 2 [Red / White / Blue, not all CGA cards]');
    1 : Writeln ('Colour [Red / Yellow / Green]');
    2 : Writeln ('Mono 1 [Cyan / Magenta / White]');
   end;
   Writeln('  - mono palettes use special symbols for planets and colonies');
   Write('[M] Choose printer type for MAPS, currently : ');
   Case Map_Choice of
   0: Writeln('Epson graphics'#10#13'  - large slow map');
   1: Writeln('Generic printer'#10#13'  - MUST be capable of 100+ character width, full screen dump N/A!');
   2: Writeln('Tandy CGP-115 Plotter/Printer'#10#13'  - SLOW, press any key to stop, full screen dump N/A!');
   3: Writeln('Epson graphics'#10#13'  - small fast map');
   end;
   Writeln('[P] Set PRINTER page size');
   Writeln('[D] DIRECTORY of all files'#10#13'[U] Directory of USER files');
   Writeln('[S] set SECURITY level, currently : ',Security_Level);
   Writeln(#10#13'[X] Return to main menu'#10#13#10#13'[H] HELP');
   Beep_Wait;
     Case Dummy of
     'B' : If Beep_on = 0 then Beep_on := 1 else Beep_On := 0;
     'M' : Begin;
             Map_Choice := Map_choice + 1;
             If Map_choice = 4 then Map_Choice := 0;
           End;
     'T' : Begin;
            Beep_Pitch := Beep_Pitch * 2;
            If Beep_Pitch >3200 then beep_Pitch := 50;
           end;
     'C' :  Begin;
             Screen_Selection := Screen_Selection + 1;
             If Screen_Selection = 3 then Screen_Selection := 0;
             Colour_Selection;
             Draw_A_Globe;
             Special_Options;
            end;
     'U' : Begin;
             Get_Directory('*.SEC');
             Get_Directory('*.DOC');
             Get_Directory('*.TXT');
             Writeln (Diskfree(0) div 1024,' kbytes free');
             Beep_Wait;
           End;
     'D' : Begin;
             Get_Directory('*.*');
             Writeln(#10#13,Diskfree(0) div 1024,' kbytes free');
             Beep_Wait;
           End;
     'P' : Setup_Printer;
     'S' : Have_A_Nice_Day; {password routine}
     'H' : Help('OPTIONS',' BTCMPDUSX');
     end;
     Until Dummy = 'X';
End;

{----------------            Main Program!!           -------------------}

Begin;
    Systems_In_Memory := 0;  {set initial variables}
    Beep_On := 1; Beep_Pitch := 400; C_Or_T := 0; Map_Choice := 3; Astral := 0;
    Demonstration := 0; Screen_Selection := 3; Security_Level := 0;
    Bypass_Setup := 0; Bypass_Title := 0;
    If Paramcount > 0 then for I := 1 to Paramcount do begin;
      If (Paramstr(I) = 'S') or (Paramstr(I) = 's') then Beep_on := 0;  {switch sound off}
      If (Paramstr(I) = 'C') or (Paramstr(I) = 'c') then Screen_Selection:= 2;
      If (Paramstr(I) = 'M1') or (Paramstr(I) = 'm1') then Screen_Selection:= 0;
      If (Paramstr(I) = 'M2') or (Paramstr(I) = 'm2') then Screen_Selection:= 1;
      If (Paramstr(I) = 'P') or (Paramstr(I) = 'p') then Bypass_Setup := 1;
      If (Paramstr(I) = 'T') or (Paramstr(I) = 't') then Bypass_Title := 1;
    end;
    Top_Of_Menu_Screens;
    Writeln('DISCLAIMER - This program does not attempt a realistic simulation');
    Writeln('of astronomical processes;  it is simplified,  and heavily biased');
    Writeln('towards the generation of interesting systems for science fiction');
    Writeln('role playing games. It produces a "friendly" universe with plenty');
    Writeln('of places to colonise, explore, and have adventures!'#10#13);
    Writeln('This program requires an IBM PC or Compatible with CGA Graphics');
    Writeln('[Hercules mono cards and text cards are NOT suitable]');
    Writeln;
    If Screen_Selection = 3 then begin;
       Writeln('IF YOU DO NOT HAVE SUITABLE GRAPHICS, PRESS "X" TO EXIT!!!'#10#13'or press any other key to continue');
       Beep_Wait;
       If Dummy = 'X' then exit;
       Writeln (#10#13'Do you have a colour monitor - Press "N" if no, or another'#10#13'key to continue');
       Beep_Wait;
       If Dummy = 'N' then Screen_Selection := 0 else Screen_Selection := 2;
    End;
    Writeln;
    If Bypass_Setup = 0 then begin;
       Writeln('Set-up may be required for your [Epson-compatible] printer:'#10#13'Press "Y" to set up');
       Beep_Wait;
       If Dummy = 'Y' then Setup_Printer;
    end;
    Colour_Selection;
    Statistics_Status := -1;
    If Bypass_Title = 0 then Titles;
    Randomize;
    Repeat
    Repeat
       Top_Of_Menu_Screens;
       Writeln('Press keys for program options'#10#10#13'[G] GENERATE new sector');
       Writeln('[S] SAVE sector         [edited or generated sector]'#10#13'[L] LOAD old sector');
       Writeln(#10#13'[V] VIEW a sector       [loaded or generated sector]');
       Writeln('[Z] ZOOM system details [loaded or generated system]');
       Writeln('[E] EDIT solar system   [loaded or generated system]');
       Writeln('[D] Sector DATA         [loaded or generated sector]');
       Writeln(#10#13'[T] TUTORIAL'#10#13'[R] ROLLING demonstration');
       Writeln(#10#13'[O] Special OPTIONS'#10#13'[Q] QUIT'#10#13#10#13'[I] INFORMATION         [H] HELP');
       If Security_Level > 1 then begin;
         WG_Textcolor(Red);
         Go_Away(1,8); Go_Away(1,13);
         If Security_Level > 2 then Go_Away(1,7);
         If Security_Level > 3 then begin;
           Go_Away(1,12); Go_Away(1,14);
         end;
         WG_Textcolor(lightGreen);
         gotoxy(1,21);
       end;
       Beep_Wait;
       Case Dummy of
         'T': Instructions;   {Display instructions}
         'G': If Security_Level < 3 then Begin;
                Status := 1;
                Draw_Grid;    {Randomly generate a sector}
                Random_Systems;
                Solar_Systems;
              End;
         'S': If Security_Level < 2 then Save_Data;      {save sector to disk}
         'L': Read_Data;      {load sector from disk}
         'V': Steer_Around_Sector;
         'Z': If Systems_In_Memory = 0 then No_Sector_error
                else if Security_Level < 4 then begin;
                Repeat;
                  Help_Used := 0;
                  Top_Of_Menu_Screens;
                  Writeln('Please select option:'#10#13'[Z] ZOOM into one solar system');
                  Writeln('[P] PLANETARIUM view of one solar system'#10#13);
                  Writeln('[G] GRAND tour of sector'#10#13#10'[H] HELP'#10#10#13'Any other key for main menu');
                  Beep_Wait;
                  Case Dummy of
                'G' : Begin
                        WG_Textcolor(white+blink);
                        Writeln('PRESS ANY KEY TO INTERRUPT TOUR');
                        delay(3000);
                        Demonstration := 1;
                        Grand_Tour;
                        demonstration := 0;
                     end;
                'Z': Planet_Details(0); {generate planet details}
                'P': Orrory (0);
                'H': Begin;
                        HELP('ZOOM',' GZP');
                        Help_Used := 1;
                     End;
                  end;
                Until Help_Used = 0;
              end;
         'E': If Security_Level < 2 then Magrathea;  {modify systems}
         'D': If Security_Level < 4 then Statistics; {Count the worlds in the sector}
         'O': Special_Options; {go to alternative menu}
         'Q': If Security_Level > 1 then begin;
               Write('Please enter password to end the program :');
               Get_Code_Word;
               If entered_code = Security_Code then Status := 9
                 else writeln('sorry - that is not the correct code');
              end else Status := 9;
         'R': Rolling_Demonstration;
         'H': HELP('MAINMEN',' GSLVZEDTROQI');
         'I': Repeat HELP('INFO',' UASGPFRVB123456789') until Dummy = ' ';
        end;
      Until Status = 9;
      GotoXY(20,20);
      WG_Textcolor(LightRed+Blink);
      Write('Are you SURE you want to quit?');
      WG_Textcolor(Yellow);
      Beep_Wait;
      If Dummy <> 'Y' then begin;
         GotoXY(20,20);
         Writeln('                              ');
         Status := 0;
      End;
   Until Status = 9;
   ClrScr;
End.
